/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.core.process;

import java.util.Iterator;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The <code>CreateSubAssetsProcess</code> is called in a workflow process step.
 * This process will fragment an asset in its subassets.
 */
@Component(metatype = false)
@Service
@Property(name = "process.label", value = "Create Sub Asset")
public class CreateSubAssetsProcess extends AbstractAssetWorkflowProcess {

    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(CreateSubAssetsProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {

        final Asset asset = getAssetFromPayload(workItem, workflowSession.getSession());
        if (null != asset) {
            //TODO - figure out a better way
            if (!asset.isSubAsset() && !isPrintAsset(asset)) {
                final AssetHandler handler = getAssetHandler(asset.getMimeType());
                handler.processSubAssets(asset);
            } else {
                log.debug("execute: skipping processing of asset [{}], it is already a sub-asset.", asset.getPath());
            }
        } else {
			String wfPayload = workItem.getWorkflowData().getPayload().toString();
			String message = "execute: cannot create sub-assets, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
			throw new WorkflowException(message);
        }
    }
    
    private boolean isPrintAsset(Asset asset){
        if (asset.getRendition("cq-indesign-print")!=null)
            return true;
        else {
            Iterator<?> relatedPages = asset.adaptTo(com.adobe.granite.asset.api.Asset.class).listRelated("pages");
            if (relatedPages.hasNext()){
                com.adobe.granite.asset.api.Asset relatedPage = (com.adobe.granite.asset.api.Asset)relatedPages.next();
                return (relatedPage.getRendition("cq-indesign-print")!=null || (StringUtils.endsWithIgnoreCase(relatedPage.getRendition("original").getMimeType(), "-indesign")));
            }
            return false;
        }
    }

}
