/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The <code>DeleteAssetProcess</code> will delete the asset content if the real
 * asset disappears.
 * <p/>
 * Example:<br>
 * /var/dam/abc.jpg is deleted via webdav --> /content/dam/abc.jpg will be
 * removed
 */
@Component(metatype = false)
@Service
@Property(name = "process.label", value = "Delete Asset")
public class DeleteAssetProcess extends AbstractAssetWorkflowProcess {
    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(DeleteAssetProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        final String binaryPath = workItem.getWorkflowData().getPayload().toString();

        // only remove the "real" asset if the corresponding file in /var/dam
        // does not exist anymore!
        if (getNodeFromPayload(workItem, workflowSession.getSession()) == null) {
            if (getAssetManager(workflowSession.getSession()).removeAssetForBinary(binaryPath)) {
                log.debug("execute: successfully removed asset [{}] for binary [{}].",
                        DamUtil.binaryToAssetPath(binaryPath), binaryPath);
            } else {
                log.error("execute: failed to remove asset [{}] for binary [{}].",
                        DamUtil.binaryToAssetPath(binaryPath), binaryPath);
            }
        }
    }
}
