/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import static com.day.cq.dam.api.DamConstants.ORIGINAL_FILE;

/**
 * This process will automatically remove the image preview rendition.
 */
@Component
@Service
@Properties({
        @Property(name = "process.label", value = "Delete Image Previews Process")
})
public class DeleteImagePreviewProcess extends AbstractAssetWorkflowProcess {

    public void execute(WorkItem item, WorkflowSession wfSession, MetaDataMap args) throws WorkflowException {
        Asset asset = getAssetFromPayload(item, wfSession.getSession());
        if (null != asset) {
            Rendition r = asset.getImagePreviewRendition();
            String name = r.getName();
            if ((name != null) && !ORIGINAL_FILE.equals(name)) {
                asset.removeRendition(name);
            }
        } else {
        	String wfPayload = item.getWorkflowData().getPayload().toString();
			String message = "execute: cannot delete image preview, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + item.getId() + "}].";
			throw new WorkflowException(message);
        }
    }

}
