/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.core.process;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;

/**
 * The <code>ExtractMetadataProcess</code> is called in a workflow process step.
 * This process will import metadata, if the paylod of the step is an
 * {@link com.day.cq.dam.api.Asset Asset} or a part of an
 * {@link com.day.cq.dam.api.Asset Asset}.
 * 
 * @see AbstractAssetWorkflowProcess
 */
@Component(metatype = true)
@Service
@Property(name = "process.label", value = "Extract Meta Data")
@Deprecated
public class ExtractMetadataProcess extends AbstractAssetWorkflowProcess {

	private MetadataExtractor metadataExtractor = new MetadataExtractor();
	private boolean sha1Enabled = false;

	@Property(boolValue = true)
	public static final String ENABLE_SHA1_GEN = "cq.dam.enable.sha1";

	/**
	 * Logger instance for this class.
	 */
	private static final Logger log = LoggerFactory.getLogger(ExtractMetadataProcess.class);

	@Reference(
			policy = ReferencePolicy.DYNAMIC,
			cardinality = ReferenceCardinality.OPTIONAL_UNARY,
			policyOption = ReferencePolicyOption.GREEDY  // ensures service-resolution to the one ranked highest
			)
	protected ContentAwareMimeTypeService contentAwareMimeTypeService;

	public void execute(WorkItem workItem, WorkflowSession workflowSession,
			MetaDataMap args) throws WorkflowException {
		try {
			final Session session = workflowSession.getSession();
			final Asset asset = getAssetFromPayload(workItem, session);
			if (null != asset) {
				asset.setBatchMode(true);
				final AssetHandler handler = getAssetHandler(asset.getMimeType());
				if (null != handler) {
					metadataExtractor.extractMetadata(session, asset, handler, sha1Enabled,
							(null != contentAwareMimeTypeService)
							? contentAwareMimeTypeService
							: mimeTypeService);
					session.save();
				} else {
					log.error(
							"execute: cannot extract metadata, no handler found for asset [{}] with mime type [{}]",
							asset.getPath(), asset.getMimeType());
				}
			} else {
				String wfPayload = workItem.getWorkflowData().getPayload()
						.toString();
				String message = "execute: cannot extract metadata, asset [{"
						+ wfPayload
						+ "}] in payload doesn't exist for workflow [{"
						+ workItem.getId() + "}].";
				throw new WorkflowException(message);
			}
		} catch (Exception e) {
			log.warn(
					"unexpected error occurred during metadata extraction. Cause: {}",
					e.getMessage(), e);
		}
	}


	@Activate
    @SuppressWarnings("unused")
    protected void Actiate(final ComponentContext context) throws RepositoryException {
        sha1Enabled = OsgiUtil.toBoolean(context.getProperties().get(ENABLE_SHA1_GEN), true);
    }
}
