/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.core.process;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamConstants;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.impl.ui.preview.AssetDrivenFolderPreviewGenerator;
import com.day.cq.dam.core.impl.ui.preview.FolderPreviewUpdater;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;

import org.apache.felix.scr.annotations.*;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The <code>UpdateFolderThumbnailProcess</code> is called in a workflow process step.
 */
@Component(metatype = false)
@Service
@Property(name = "process.label", value = "Update Folder Thumbnail Process")
public class UpdateFolderThumbnailProcess extends AbstractAssetWorkflowProcess {

    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(UpdateFolderThumbnailProcess.class);

    @Reference
    private FolderPreviewUpdater folderPreviewUpdater;

    public void updateFolderThumbnail(Asset asset, Node assetNode, FolderPreviewUpdater folderPreviewUpdater) throws RepositoryException {
        final Resource resource = asset.adaptTo(Resource.class);
        Resource parentFolderResource = resource.getParent();

        Node parentFolderNode = assetNode.getParent();
        String folderPath = parentFolderNode.getPath();

        if (parentFolderNode.isNodeType("nt:folder") && !folderPath.equals(DamConstants.MOUNTPOINT_ASSETS)) {

            AssetDrivenFolderPreviewGenerator generator = new AssetDrivenFolderPreviewGenerator(asset, parentFolderResource, false);
            if (generator.isFolderThumbnailNeedToBeUpdated()) {
                boolean success = folderPreviewUpdater.initiateFolderPreviewUpdate(asset.getPath());
                if (!success) {
                    log.error("Folder thumbnail update couldn't be initiated for assset {}", asset.getPath());
                }
            }
        }

    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        final Asset asset = getAssetFromPayload(workItem, workflowSession.getSession());
        if (asset != null) {
            Node assetNode = asset.adaptTo(Node.class);
            try {
                updateFolderThumbnail(asset, assetNode, folderPreviewUpdater);
            } catch (Exception e) {
                log.error("Error while updating folder thumbnail of asset {}", asset.getPath(), e);
            }
        } else {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot update folder thumbnail, asset [{" + wfPayload
                + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
    }
}
