/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2014, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.day.cq.dam.drive.common;

import javax.mail.Flags;

/**
 * Constants that indicate whether a file is in a camera-raw format, and whether
 * it is associated with XMP metadata. Collected in a {@link Flags} list, which
 * is part of the <tt>BasicData</tt> for an <tt>UpdateRecipe</tt> as per
 * Connector API.
 */
public enum Flag {
    /** File format is camera raw. */
    CAMERA_RAW,
    /** File is associated with XMP metadata. */
    HAS_XMP,
    /** File is associated with Icons */
    HAS_ICON
}
