/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2014, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.day.cq.dam.drive.servlet;

import java.io.IOException;
import java.util.Dictionary;

import javax.servlet.ServletException;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Returns the version number of installed optimization package
 */
@Component(metatype = true)
@Service
@Properties({
    @org.apache.felix.scr.annotations.Property(name = "sling.servlet.resourceTypes", value = "sling/servlet/default", propertyPrivate = true),
    @Property(name = "sling.servlet.methods", value = { "GET" }),
    @Property(name = "sling.servlet.extensions", value = "json"),
    @Property(name = "sling.servlet.selectors", value = { "drivePackageInfo" }) })
public class OptimizationPackageInfoServlet extends SlingAllMethodsServlet {

    /** logger */
    private static Logger log = LoggerFactory.getLogger(OptimizationPackageInfoServlet.class);

    private static String BUNDLE_VERSION = "Bundle-Version";

    private static String version;

    protected void doGet(final SlingHttpServletRequest request,
            final SlingHttpServletResponse response) throws ServletException,
            IOException {
        JSONObject json = new JSONObject();
        try {
            json.put("version", version);
            json.write(response.getWriter());
        } catch (JSONException e) {
           log.error("Error in returning the optimization version",e);
        }

    }

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        Dictionary dict = componentContext.getBundleContext().getBundle().getHeaders();
        version = dict.get(BUNDLE_VERSION).toString();
    }

}
