/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2014, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.day.cq.dam.drive.util;

import java.util.Iterator;
import java.util.List;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.Constants;

import com.day.cq.dam.api.DamConstants;
import com.day.cq.dam.api.RenditionPicker;

/**
 * A {@link RenditionPicker} that picks the first rendition found which name
 * starts with a given prefix.
 */
@Service(value = DriveRenditionPicker.class)
@Component(metatype = true)
@Properties({ @Property(name = Constants.SERVICE_RANKING, intValue = 400, propertyPrivate = false), })
public class PrefixRenditionPicker implements DriveRenditionPicker {

    private String prefix;

    private boolean returnOriginal;

    /**
     * Picks the first rendition found which name starts with the given prefix.
     * If no matching rendition was found, <code>null</code> will be returned.
     * 
     * @param startsWith the name prefix to match
     */
    public PrefixRenditionPicker(String startsWith) {
        this(startsWith, false);
    }

    public PrefixRenditionPicker() {

    }

    /**
     * Picks the first rendition found which name starts with the given prefix.
     * It can be defined what to return if no matching rendition was found
     * (original rendition or <code>null</code>).
     * 
     * @param prefix the name prefix to match
     * @param returnOriginal if true, will return the original rendition if no
     *            matching rendition was found, otherwise the picker will return
     *            <code>null</code>
     */
    public PrefixRenditionPicker(String prefix, boolean returnOriginal) {
        this.prefix = prefix;
        this.returnOriginal = returnOriginal;
    }

    public Resource getRendition(final Iterator<Resource> renditions) {
        Resource original = null;
        while (renditions.hasNext()) {
            final Resource rendition = renditions.next();
            if (DamConstants.ORIGINAL_FILE.equals(rendition.getName())) {
                original = rendition;
            }
            if (rendition.getName().startsWith(prefix)) {
                return rendition;
            }
        }

        if (returnOriginal) {
            // 2. return current rendition
            return original;
        } else {
            return null;
        }
    }

    public String getId() {
        return "prefix";
    }

    public Resource getPreviewRendition(List<Resource> renditions) {
        return null;
    }

    public Resource getThumbnailRendition(List<Resource> renditions) {
         return null;
    }

}
