/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2014, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.day.cq.dam.drive.util;

import java.util.List;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Constants;
import org.osgi.service.component.ComponentContext;

@Service(value = DriveRenditionPicker.class)
@Component(metatype = true)
@Properties({ @Property(name = Constants.SERVICE_RANKING, intValue = 600, propertyPrivate = false), })
public class WidthBasedRenditionPickerImpl implements DriveRenditionPicker {

    int thumbnailWidth;

    int previewWidth;

    @Property(intValue = 319, label = "Width for thumbnail rendition", description = "Allows to specify the rendition width for thumbnails")
    public static final String THUMBNAIL_WIDTH = "cq.dam.asset.thumbnail.width";

    @Property(intValue = 1280, label = "Width for preview rendition", description = "Allows to specify the rendition width for previews")
    public static final String PREVIEW_WIDTH = "cq.dam.asset.preview.width";

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        thumbnailWidth = OsgiUtil.toInteger(
            componentContext.getProperties().get(THUMBNAIL_WIDTH), 319);
        previewWidth = OsgiUtil.toInteger(
            componentContext.getProperties().get(PREVIEW_WIDTH), 1280);
    }

    public Resource getPreviewRendition(List<Resource> renditions) {
        return DriveUtil.getBestFitRendition(previewWidth, renditions);
    }

    public Resource getThumbnailRendition(List<Resource> renditions) {
        return DriveUtil.getBestFitRendition(thumbnailWidth, renditions);
    }

}
