package com.day.cq.dam.handler.standard.keynote;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import com.day.image.Layer;

/**
 * The <code>KeynoteBaseSlide</code> is the basis for all keynote slides like:
 * slides and master slides
 */
public abstract class KeynoteBaseSlide {
	private Element element;
	private KeynotePresentation preso;
	private String thumbnail;
	private String id;
	private Collection<String> resources = new HashSet<String>();
	
	public KeynoteBaseSlide(Element element, KeynotePresentation keynotePresentation) {
		this.element = element;
		this.preso = keynotePresentation;
		this.id = element.getAttributeNS(KeynotePresentation.NAMESAPCES_SFA, "ID");

        // thumbnail
        DocumentTraversal dt = (DocumentTraversal) element.getOwnerDocument();
        NodeIterator nit = dt.createNodeIterator(element, NodeFilter.SHOW_ELEMENT, new NodeFilter() {

            public short acceptNode(Node n) {
                Element e = (Element) n;
                if (e.getLocalName().equals("binary")) {
                    if (e.getParentNode().getLocalName().equals("thumbnails")) {
                        return NodeFilter.FILTER_SKIP;
                    }
                }
                if (e.getLocalName().equals("data")) {
                    if (e.getParentNode().getLocalName().equals("binary")) {
                        if (e.getParentNode().getParentNode().getLocalName().equals("thumbnails")) {
                            return NodeFilter.FILTER_ACCEPT;
                        }
                    }
                }
                if (e.getLocalName().equals("thumbnails")) {
                    return NodeFilter.FILTER_SKIP;
                }
                return NodeFilter.FILTER_REJECT;
            }
        }, true);
        Element next;
        while ((next = (Element) nit.nextNode())!=null) {
            this.thumbnail = next.getAttributeNS(KeynotePresentation.NAMESAPCES_SF, "path");
        }

		// resources
        DocumentTraversal rdt = (DocumentTraversal) element.getOwnerDocument();
        NodeIterator rnit = rdt.createNodeIterator(element, NodeFilter.SHOW_ELEMENT, new ElementFilter(NodeFilter.FILTER_SKIP)
            .acceptNodes(KeynotePresentation.NAMESAPCES_SF, "data", "main-movie"), true);
        Element rnext;
        while ((rnext = (Element) rnit.nextNode())!=null) {
            this.resources.add(rnext.getAttributeNS(KeynotePresentation.NAMESAPCES_SF, "path"));
        }
	}

    /**
     * Get slide id
     *
     * @return slide id
     */
	public String getId() {
		return id;
	}

    /**
     * Get thumbnail representation of image
     * @return
     */
	public BufferedImage getThumbnail() {
		if (this.thumbnail!=null&&this.thumbnail.length()!=0) {
			try {
				return new Layer(this.preso.getResource(this.thumbnail)).getImage();
			} catch (IOException e) {
				return null;
			}
		} else {
			return null;
		}
	}

    protected Collection<String> getResources() {
		return this.resources;
	}

    protected void removeElement() {
		this.element.getParentNode().removeChild(this.element);
	}

}
