package com.day.cq.dam.handler.standard.keynote;

import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

/**
 * The <code>KeynoteSlide</code> represents a single keynote slide.
 */
public class KeynoteSlide extends KeynoteBaseSlide {
	private boolean hidden;
	private KeynoteMasterSlide master;
	
	public KeynoteSlide(Element element, KeynotePresentation keynotePresentation) {
		super(element, keynotePresentation);

		this.hidden = Boolean.parseBoolean(element.getAttributeNS(KeynotePresentation.NAMESPACES_KEYNOTE2, "hidden"));
		
		DocumentTraversal dt = (DocumentTraversal) element.getOwnerDocument();
		NodeIterator nit = dt.createNodeIterator(element, NodeFilter.SHOW_ELEMENT, 
				new ElementFilter(NodeFilter.FILTER_REJECT)
					.skipNodes(KeynotePresentation.NAMESPACES_KEYNOTE2, "slide")
					.acceptNodes(KeynotePresentation.NAMESPACES_KEYNOTE2, "master-ref"), true);
		Element masterRefNode =  (Element) nit.nextNode();
		if (masterRefNode!=null) {
			String mastername = masterRefNode.getAttributeNS(KeynotePresentation.NAMESAPCES_SFA, "IDREF");
			this.master = keynotePresentation.getMaster(mastername);
		}
	}

    /**
     * Get "view" status.
     *
     * @return <code>true</code> if slide is marked as hidden
     */
	public boolean isHidden() {
		return hidden;
	}

    /**
     * Get slide master for this slide
     *
     * @return slide master
     */
	public KeynoteMasterSlide getMaster() {
		return master;
	}
}
