/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.handler.standard.msoffice;

import static com.day.cq.dam.api.DamConstants.DC_CREATOR;
import static com.day.cq.dam.api.DamConstants.DC_DESCRIPTION;
import static com.day.cq.dam.api.DamConstants.DC_TITLE;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import java.util.HashMap;
import java.util.Map;

public class IdToNameMap {

    private static final Map<Long, String> summaryMap = new HashMap<Long, String>();
    private static final Map<Long, String> documentPropertyMap = new HashMap<Long, String>();
    static {
        summaryMap.put((long)PropertyIDMap.PID_TITLE, DC_TITLE);
        summaryMap.put((long)PropertyIDMap.PID_SUBJECT, DC_DESCRIPTION);
        summaryMap.put((long)PropertyIDMap.PID_AUTHOR, DC_CREATOR);
        summaryMap.put((long)PropertyIDMap.PID_KEYWORDS, "Keywords");
        summaryMap.put((long)PropertyIDMap.PID_COMMENTS, "Comments");
        summaryMap.put((long)PropertyIDMap.PID_TEMPLATE, "Template");
        summaryMap.put((long)PropertyIDMap.PID_LASTAUTHOR, "LastAuthor");
        summaryMap.put((long)PropertyIDMap.PID_REVNUMBER, "RevNumber");
        summaryMap.put((long)PropertyIDMap.PID_EDITTIME, "EndTime");
        summaryMap.put((long)PropertyIDMap.PID_LASTPRINTED, "LastPrinted");
        summaryMap.put((long)PropertyIDMap.PID_CREATE_DTM, "CreateDateTime");
        summaryMap.put((long)PropertyIDMap.PID_LASTSAVE_DTM, "LastSaveDateTime");
        summaryMap.put((long)PropertyIDMap.PID_PAGECOUNT, "PageCount");
        summaryMap.put((long)PropertyIDMap.PID_WORDCOUNT, "WordCount");
        summaryMap.put((long)PropertyIDMap.PID_CHARCOUNT, "CharCount");
        summaryMap.put((long)PropertyIDMap.PID_THUMBNAIL, "Thumbnail");
        summaryMap.put((long)PropertyIDMap.PID_APPNAME, "creatortool");
        summaryMap.put((long)PropertyIDMap.PID_SECURITY, "Security");
    }
    static {
        documentPropertyMap.put((long)PropertyIDMap.PID_DICTIONARY, "Dictionary");
        documentPropertyMap.put((long)PropertyIDMap.PID_CODEPAGE, "CodePage");
        documentPropertyMap.put((long)PropertyIDMap.PID_CATEGORY, "Category");
        documentPropertyMap.put((long)PropertyIDMap.PID_PRESFORMAT, "PresentationFormat");
        documentPropertyMap.put((long)PropertyIDMap.PID_BYTECOUNT, "ByteCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_LINECOUNT, "LineCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_PARCOUNT, "ParCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_SLIDECOUNT, "SlideCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_NOTECOUNT, "NoteCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_HIDDENCOUNT, "HiddenCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_MMCLIPCOUNT, "MMClipCount");
        documentPropertyMap.put((long)PropertyIDMap.PID_SCALE, "Scale");
        documentPropertyMap.put((long)PropertyIDMap.PID_HEADINGPAIR, "HeadingPair");
        documentPropertyMap.put((long)PropertyIDMap.PID_DOCPARTS, "DocParts");
        documentPropertyMap.put((long)PropertyIDMap.PID_MANAGER, "Manager");
        documentPropertyMap.put((long)PropertyIDMap.PID_COMPANY, "Company");
        documentPropertyMap.put((long)PropertyIDMap.PID_LINKSDIRTY, "LinksDirty");
    }

    static String getSummaryPropertyName(long id) {
        if (summaryMap.containsKey(id)) {
            return (String) summaryMap.get(id);
        }
        return Long.toString(id);
    }
    
    static String getDocumentPropertyName(long id) {
        if (documentPropertyMap.containsKey(id)) {
            return (String) documentPropertyMap.get(id);
        }
        return Long.toString(id);
    }
}
