/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.handler.standard.msoffice;

import static org.apache.poi.hpsf.Variant.VT_FILETIME;
import static org.apache.poi.hpsf.Variant.VT_LPSTR;
import static org.apache.poi.hpsf.Variant.VT_LPWSTR;
import static org.apache.poi.hpsf.Variant.VT_I2;
import static org.apache.poi.hpsf.Variant.VT_I4;
import static org.apache.poi.hpsf.Variant.VT_BOOL;

import com.day.cq.dam.api.metadata.ExtractedMetadata;

import java.util.Calendar;
import java.util.Date;

public class MSOfficeMetadata extends ExtractedMetadata {

    /**
     * Set Metadata property
     * @param name readable property name
     * @param value as acquired
     * @param type property type as defined in #org.apache.poi.hpsf.Variant
     * */
    public void setProperty(String name, Object value, long type) {
        if (type == VT_FILETIME) { // file Date
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date) value);
            super.setMetaDataProperty(name, calendar);
        } else if (type == VT_LPSTR  // null terminated string
                || type == VT_LPWSTR // wide (Unicode) null terminated string
                || type == VT_I2 // 2 byte signed int
                || type == VT_I4 // 4 byte signed int
                || type == VT_BOOL) {  // boolean
            super.setMetaDataProperty(name, value);
        }
        // else ignore it, for now.
    }
}
