/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.indd;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;

import java.util.HashMap;
import java.util.Map;

/**
 * Extraction handler base class.
 * <p/>
 * This base class provides the page creation relevant parts of the page extraction process, based on the {@link PageBuilder}.
 */
@Component(componentAbstract = true)
public abstract class AbstractPageExtractionHandler implements PageExtractionHandler {

    @Reference
    PageBuilderFactory pageBuilderFactory;


    protected PageBuilder getPageBuilder(ResourceResolver resourceResolver) {
        if (pageBuilderFactory != null && resourceResolver != null) {
            return pageBuilderFactory.getPageBuilder(resourceResolver);
        } else {
            return null;
        }
    }

    protected PageComponent createParComponent(PageBuilder pageBuilder) {
        Map<String, Object> properties = new HashMap<String, Object>();
        return pageBuilder.createComponent("foundation/components/parsys", new ValueMapDecorator(properties), "par");
    }

    protected PageComponent createTitleComponent(PageBuilder pageBuilder, String pageTitle) {
        Map<String, Object> properties = new HashMap<String, Object>();
        properties.put("jcr:title", pageTitle);
        return pageBuilder.createComponent("foundation/components/title", new ValueMapDecorator(properties));
    }

}
