/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.indd;

import org.apache.sling.api.resource.ResourceResolver;

/**
 * Factory service to create {@link PageBuilder}s.
 * <p/>
 * This interface must not be implemented by clients.
 *
 * @since 5.5
 */
public interface PageBuilderFactory {

    /**
     * Get a new {@link PageBuilder} instance.
     *
     * @param resourceResolver The {@link ResourceResolver} for the new {@link PageBuilder}.
     * @return The new {@link PageBuilder}.
     */
    public PageBuilder getPageBuilder(ResourceResolver resourceResolver);
}
