/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.indd;

import org.apache.sling.api.resource.ValueMap;

import java.util.List;

/**
 * This interface defines a type for a page component.
 * <p/>
 * A {@link PageComponent} is a generic representation of wcm component. It consists of a resource type and properties to
 * describe a component. Resource type and properties are specific for a certain component.
 * <p/>
 * Further, {@link PageComponent}s can be nested.
 * <p/>
 * This interface must not be implemented by clients.
 *
 * @since 5.5
 */
public interface PageComponent {

    /**
     * Get the nested {@link PageComponent}s.
     *
     * @return A list of the nested page components.
     */
    public List<PageComponent> getChildComponents();

    /**
     * Get the page component's resource type.
     *
     * @return The page component's resource type.
     */
    public String getResourceType();

    /**
     * The the page component's properties.
     *
     * @return The component's properties.
     */
    public ValueMap getProperties();

    /**
     * Get the page component's name hint.
     *
     * @return The page component's name hint.
     */
    public String getNameHint();

}
