/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.indd;

import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.wcm.api.Page;

/**
 * The PageExtractionHandler service.
 * <p/>
 * This interface provides an extension point for the page extraction process as performed with the
 * {@link com.day.cq.dam.indd.process.INDDPageExtractProcess}.
 * <p/>
 * Clients must implements this interface and provide as a service component in case they want to provide custom logic to create
 * a {@link Page} from a {@link Rendition}. Implementations must indicate the rendition they are supporting by implementing
 * {@link #getRenditionPicker()}. The extraction as per {@link #extractPage(com.day.cq.dam.api.Rendition, String, String, String, String, String)}
 * is only performed if a rendition as per {@link #getRenditionPicker()} is found on the asset.
 * <p/>
 * Available implementations can be listed using the {@link com.day.cq.dam.indd.impl.servlet.PageExtractionHandlerListServlet} at
 * /libs/dam/content/indesign/extractionhandler.list.json
 * <p/>
 * Clients are encouraged to extend from the provided {@link AbstractPageExtractionHandler}.
 *
 * @since 5.5
 */
public interface PageExtractionHandler {

    /**
     * Service property to provide a label for the implementation.
     * <p/>
     * Currently used in the listing of {@link com.day.cq.dam.indd.impl.servlet.PageExtractionHandlerListServlet}.
     */
    public static final String SERVICE_PROPERTY_LABEL = "extractionhandler.label";

    /**
     * Service property to provide a description for the implementation.
     * <p/>
     * Currently used in the listing of {@link com.day.cq.dam.indd.impl.servlet.PageExtractionHandlerListServlet}.
     */
    public static final String SERVICE_PROPERTY_DESCRIPTION = "extractionhandler.description";

    /**
     * Extract a {@link Page} from the given {@link Rendition}.
     * <p/>
     * The parameters are set by the configuration of the {@link com.day.cq.dam.indd.process.INDDPageExtractProcess}.
     *
     * @param extractedRendition The renditions to extract the page from.
     * @param pageRoot           The root path for the page.
     * @param pageName           The page name.
     * @param pageTitle          The page title.
     * @param pageTemplate       The page template.
     * @param pageDesign         The design
     * @return Page The extracted page.
     * @throws PageExtractionException
     */
    public Page extractPage(Rendition extractedRendition, String pageRoot, String pageName, String pageTitle, String pageTemplate, String pageDesign) throws PageExtractionException;

    /**
     * Get the rendition picker.
     * <p/>
     * Implementations must provide a {@link RenditionPicker} to indicate what renditions they can handle.
     *
     * @return The rendition picker.
     */
    public RenditionPicker getRenditionPicker();
}
