/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.performance.api;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * The <code>AssetPerformanceConfigProvider</code> interface provide methods for
 * retrieving the Asset Insight configurations.
 */
@ProviderType
public interface AssetPerformanceConfigProvider {

    /**
     * Gets the SiteCatalyst cloud service config path.
     *
     * @param resource used for resolving the configuration paths
     * @return the SiteCatalyst cloud service config path
     */
    String getSiteCatalystCloudServiceConfigPath(Resource resource);

    /**
     * Gets the SiteCatalyst cloud service config path.
     *
     * @param resolver, used for resolving the configuration paths
     * @return the SiteCatalyst cloud service config path
     */
    String getSiteCatalystCloudServiceConfigPath(ResourceResolver resolver);

    /**
     * Gets the SiteCatalyst list variable for the Asset Impression
     * Success Event.
     *
     * @param resolver, used for resolving the configuration paths
     */
    String getAssetIdImpressionListVar(ResourceResolver resolver);

    /**
     * Gets the SiteCatalyst eVar variable for the Asset Click
     * Success Event.
     *
     * @param resolver, used for resolving the configuration paths
     */
    String getAssetIdClickEVar(ResourceResolver resolver);

    /**
     * Gets the SiteCatalyst Asset Impression success event.
     *
     * @param resolver, used for resolving the configuration paths
     */
    String getAssetImpressionSuccessEvent(ResourceResolver resolver);

    /**
     * Gets the SiteCatalyst Asset Click success event.
     *
     * @param resolver, used for resolving the configuration paths
     */
    String getAssetClickSuccessEvent(ResourceResolver resolver);

    /**
     * Gets the SiteCatalyst ReportSuite configured with the
     * <i>scConfiguration</i>.
     */
    String getSCConfiguredReportSuite(Configuration scConfiguration);

    /**
     * Gets the SiteCatalyst Visitor Namespace configured with the
     * <i>scConfiguration</i>.
     */
    String getSCConfiguredVisitorNamespace(Configuration scConfiguration);

    /**
     * Gets the SiteCatalyst Tracking Server configured with the
     * <i>scConfiguration</i>.
     */
    String getSCConfiguredTrackingServer(SlingHttpServletRequest request,
            Configuration scConfiguration);

    /**
     * Gets the Asset Insight - SiteCatlyst configuration.
     *
     * @param resolver, used for resolving the configuration paths
     */
    Configuration getSCConfiguration(ResourceResolver resolver);
}
