/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.performance.api;

import org.apache.sling.api.resource.PersistenceException;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.dam.api.Asset;

/**
 * The <code>AssetPerformanceTracker</code> interface provides the methods for
 * reading and setting the asset performance record.
 */
@ProviderType
public interface AssetPerformanceTracker {

    /**
     * Gets the asset impression count for the <code>asset</code>.
     */
    long getAssetImpressionCount(Asset asset);

    /**
     * Gets the asset impression count for the <code>asset</code>.
     */
    long getAssetClickCount(Asset asset);

    /**
     * Sets the asset click count for the <code>asset<code>.
     */
    void setAssetClick(Asset asset, Long count) throws PersistenceException;

    /**
     * Sets the asset click impression for the <code>asset<code>.
     */
    void setAssetImpression(Asset asset, Long count)
            throws PersistenceException;

    /**
     * Sets the asset click and impression count for the <code>asset</code.
     */
    void setAssetPerformance(Asset asset, Long impressionCount, Long clickCount)
            throws PersistenceException;
}
