/*
 *
 * ADOBE CONFIDENTIAL
 * __________________

 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.

 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.dam.pim;

import java.io.IOException;
import java.io.InputStream;


/**
 *
 */
public class PIMHelper {

    /**
     * this skips the number of bytes that represents the BOM from the
     * inputstream, so that BOM does not appear as invalid characters in the
     * output rendition. Otherwise Layer will try to render BOM also as a
     * character and eventually ends up in showing a invalid character as the
     * first character in the rendition.
     */
    public static void skipBOM(InputStream stream, String encodingFormat)
            throws IOException {
        if (encodingFormat != null) {
            if (encodingFormat.contains("UTF-16")) {
                stream.skip(2);
            } else if (encodingFormat.contains("UTF-32")) {
                stream.skip(4);
            }
        }
    }

}
