/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7;

import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.dam.scene7.api.Scene7UploadService;

/**
 * The <code>Scene7Service</code> provides methods for interacting with the official Scene7 API.
 * 
 * @deprecated This interface might be removed in the future. Please change your code so that it uses
 *             {@link com.day.cq.dam.scene7.api.Scene7Service}.
 */
@Deprecated
public interface Scene7Service {

    /**
	 * Returns a unique user handle from Scene7.
	 * 
	 * @param resourceResolver
	 *            resource resolver used to access Scene7 configuration
	 * @param email
	 *            E-Mail address
	 * @param password
	 *            Password
	 * @param region
	 *            Region of the Scene7 service
	 * @return A unique user handle
	 */
	String getUserHandle(ResourceResolver resourceResolver, String email,
			String password, String region);

    /**
	 * Returns a JSON representation of the company membership information
	 * provided by Scene7. The information include a company handle, a company
	 * name and an asset root path.
	 * <p>
	 * For example:<br>
	 * <code>
	 * {<br>
	 * handle: 'jlkj98',<br>
	 * name: 'Acme Ltd.',<br>
	 * rootPath: '/MyAssets'<br>
	 * }
	 * </code>
	 * </p>
	 * 
	 * @param resourceResolver
	 *            resource resolver used to access Scene7 configuration
	 * @param userHandle
	 *            Unique user handle
	 * @param email
	 *            E-Mail address
	 * @param password
	 *            Password
	 * @param region
	 *            Region of the Scene7 service
	 * @return A JSON string
	 */
	String getCompanyMembership(ResourceResolver resourceResolver,
			String userHandle, String email, String password, String region);

    /**
     * Uploads a file at a given repository path to the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param email
     *            E-Mail address
     * @param password
     *            Password
     * @param region
     *            Region of the Scene7 service
     * @param userHandle
     *            Unique user handle
     * @param companyHandle
     *            Unique company handle
     * @param rootPath
     *            Scene7 root path to upload the file to
     * @param resolver
     *            Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a representation of the job handle if upload failed.
     * @deprecated Please use the {@code uploadFile} method from the {@link Scene7UploadService} instead.
     */
    @Deprecated
	String uploadFile(String path, String email, String password, String region, String userHandle, String companyHandle, String rootPath,
            ResourceResolver resolver);

}