/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;

/**
 * The {@code Scene7AssetMimeTypeService} is responsible for identifying the Scene7 "fake" mime type for the various S7 imported assets.
 */
public interface Scene7AssetMimetypeService {

    static final String SCR_PROP_NAME_ASSET_MIMETYPES = "cq.dam.scene7.assetmimetypeservice.mapping";
    static final String[] SCR_PROP_DEFAULT_ASSET_MIMETYPES = new String[] { "Generic=image/s7asset", "Template=image/s7template",
			"Flash=image/s7flashtemplate", "Image=image/*", "Image=image/jpeg",
			"Video=video/*", "Video.mp4=video/mp4", "Video.f4v=video/mp4",
			"Video.flv=video/x-flv", "PDF=application/pdf" };

	static final String REL_PATH_MIME_TYPES = "mimeTypes";

    /**
     * Returns a configured MIME type for a CQ DAM asset imported from Scene7.
     * 
     * @param asset
     *            the CQ DAM asset
     * @return a String containing the MIME type or <strong>null</strong> if no MIME type has been identified
     */
    public String getMimeTypeForAsset(Asset asset);

    /**
     * Returns a configured mime type for a Scene7 asset type.
     * 
     * @param assetType
     *            the asset type
     * @param extension
     *            the extension for the asset
     * @return a String containing the MIME type or <strong>null</strong> if no MIME type has been identified
     */
    public String getMimeTypeForAssetType(Scene7AssetType assetType, String extension);

	/**
	 * Returns a list of supported MIME types
	 * 
	 * @return a list of String of MIME types
	 */
	public List<String> getSupportedMimeTypes();

	/**
	 * Updates the list of supported MIME types from OSGi configuration to
	 * 
	 * @param s7ConfigResource
	 *            the targeted Scene7 cloud configuration
	 * @param rr
	 *            resource resolver to update Scene7 configuration resource
	 */
	public void updateSupportedMimeTypes(Resource s7ConfigResource,
			ResourceResolver rr);

	/**
	 * Updates the list of supported MIME types from OSGi configuration to
	 */
	public void updateSupportedMimeTypes();

}
