/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import java.net.URL;
import java.util.List;

/**
 * The {@code Scene7EndpointsManager} is responsible for monitoring and providing endpoints' details to services that need this information.
 */
public interface Scene7EndpointsManager {

    static final String ENDPOINTS_ROOT_FOLDER = "/etc/cloudservices/scene7/endpoints";
    static final String ENDPOINT_RESOURCE_TYPE = "dam/components/scene7/scene7Endpoint";
    static final String API_URL_PROP = "apiURL";
    static final String IPS_URL_PROP = "ipsURL";
    static final String SPS_URL_PROP = "spsURL";
    static final String VIEWERSDK_URL_PROP = "viewersdkURL";
    static final String API_VERSION_PROP = "apiVersion";

    /**
     * Returns the URL for the API server corresponding to a region.
     *
     * @param region
     * @return an {@link URL} object representing the API server URL
     */
    URL getAPIServer(String region);

    /**
     * Returns the URL for the IPS server corresponding to a region.
     *
     * @param region
     * @return an {@link URL} object representing the IPS server URL
     */
    URL getIPSServer(String region);

    /**
     * Returns the URL for the SPS server corresponding to a region.
     * 
     * @param region
     * @return an {@link URL} object representing the SPS server URL
     */
    URL getSPSServer(String region);

    /**
     * Returns the URL for the viewer SDK corresponding to a region.
     * 
     * @param region
     * @return an {@link URL} object representing the viewer SDK URL
     */
    URL getViewerSdkServer(String region);

    /**
     * Returns the API version of servers from a region.
     *
     * @param region
     * @return API version
     */
    String getAPIVersion(String region);

    /**
     * Returns a list of the registered Scene7 endpoints.
     *
     * @return the endpoints
     */
    List<Scene7Endpoint> getScene7Endpoints();

}
