/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONObject;

import com.day.cq.dam.scene7.api.constants.FlashTemplateAssetConstants;

/**
 * The {@code Scene7FlashTemplatesService} provides a way to interact with flash templates (dynamic banners) served by the Scene7 service.
 */
public interface Scene7FlashTemplatesService {

    static final String MODIFIERS = "modifiers";
    static final String FILE_REFERENCE = "fileReference";
    static final String MANUAL_MODIFIERS = "manualModifiers";
    static final String OUTPUT_TYPE = "outputType";
    
    static final String FLASH_OUTPUT_TYPE = "swf";

    static final String SCR_PROP_NAME_URL_FORMAT_PARAMETER = "scene7FlashTemplate.urlFormatParameter";
    static final String SCR_PROP_DEFAULT_URL_FORMAT_PARAMETER = "fmt";
    
    static final String SCR_PROP_NAME_REPLACE_TEXT_INSTANCE = "scene7FlashTemplates.rti";
    static final String SCR_PROP_DEFAULT_REPLACE_TEXT_INSTANCE = "rti";

    static final String SCR_PROP_NAME_REPLACE_SYMBOL_INSTANCE = "scene7FlashTemplates.rsi";
    static final String SCR_PROP_DEFAULT_REPLACE_SYMBOL_INSTANCE = "rsi";

    static final String SCR_PROP_NAME_REPLACE_BITMAP_INSTANCE = "scene7FlashTemplates.rb";
    static final String SCR_PROP_DEFAULT_REPLACE_BITMAP_INSTANCE = "rb";

    static final String SCR_PROP_NAME_REPLACE_URLS = "scene7FlashTemplates.rurl";
    static final String SCR_PROP_DEFAULT_REPLACE_URLS = "rurl";

    /**
     * Queries the path to a Scene7 dynamic banner asset and retrieves the banner's assets as a JSON object.
     * 
     * @param resource
     *            the resource identifying the dynamic banner
     * @param assetType
     *            the asset type for which the JSON object should be built
     * @return a JSON object containing the information about the banner's assets
     */
    JSONObject getFlashTemplateAssets(Resource resource, FlashTemplateAssetConstants assetType);

    /**
     * Given a Resource representing an abstractization of a flash template's elements, this method will return the URL needed for
     * dynamically modifying the template using the S7 services.
     * 
     * @param resource
     *            the Resource representing the flash template
     * @return the parametrised URL used for modifying the template
     */
    String getFlashTemplateModifyURL(Resource resource);
    
    /**
     * Based on a Resource abstractisation of a flash template will return true only if the selected rendering format is not Flash
     * 
     * @param resource
     *            the Resource representing the flash template
     * @return true if the rendering format is not Flash, false otherwise
     */
    boolean renderAsHTML(Resource resource);
}
