/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>Scene7Service</code> provides methods for interacting with the official Scene7 API.
 */
@ProviderType
public interface Scene7UploadService {

    /**
     * Uploads a file at a given repository path to the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param cloudServiceConfigPath
     * @param resolver               Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String uploadFile(String path, String cloudServiceConfigPath, ResourceResolver resolver);

    /**
     * Uploads a folder at a given repository path to the Scene7 server.
     * 
     * @param path
     *            to the folder
     * @param cloudServiceConfigPath
     * @param resolver
     *            Sling ResourceResolver to access DAM asset resource / node and
     *            AEM-S7 cloud configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String uploadFolder(String path, String cloudServiceConfigPath,
            ResourceResolver resolver);

    /**
     * Uploads a folder at a given repository path to the Scene7 server.
     * 
     * @param path
     *            to the folder
     * @param cloudServiceConfigPath
     * @param assetResolver
     *            Sling ResourceResolver to access DAM asset resource / node
     * @param configResolver
     *            Sling ResourceResolver to access AEM-S7 cloud configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String uploadFolder(String path, String cloudServiceConfigPath,
            ResourceResolver assetResolver, ResourceResolver configResolver);

    /**
     * Synchronises a file at a given repository path back into the Scene7
     * server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param resolver
     *            Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     * @deprecated No longer supported. Replaced by
     *             {@link com.day.cq.dam.scene7.api.Scene7UploadService#synchronizeFile(String, ResourceResolver, ResourceResolver)}
     */
    @Deprecated
    String synchronizeFile(String path, ResourceResolver resolver);

    /**
     * Synchronises a file at a given repository path back into the Scene7
     * server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access DAM asset resource / node
     * @param configResolver
     *            Sling ResourceResolver to access AEM-S7 cloud configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String synchronizeFile(String path, ResourceResolver assetResolver,
            ResourceResolver configResolver);

    /**
     * Moves an S7 managed file ( a file that has an associated S7 assetHandle)
     * at a given repository path back into the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param resolver
     *            Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     * @deprecated No longer supported. Replaced by
     *             {@link com.day.cq.dam.scene7.api.Scene7UploadService#moveFile(String, ResourceResolver, ResourceResolver)}
     */
    @Deprecated
    String moveFile(String path, ResourceResolver resolver);

    /**
     * Moves an S7 managed file ( a file that has an associated S7 assetHandle)
     * at a given repository path back into the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access DAM asset resource / node
     * @param configResolver
     *            Sling ResourceResolver to access AEM-S7 cloud configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String moveFile(String path, ResourceResolver assetResolver,
            ResourceResolver configResolver);

    /**
     * Moves a folder (including sub folders/assets) back to the Scene7 server.
     * 
     * @param dstpath
     *            destination path to the file in the repository
     * @param srcpath
     *            Original path of the folder in the repository
     * @param resolver
     *            Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     * @deprecated No longer supported. Replaced by
     *             {@link com.day.cq.dam.scene7.api.Scene7UploadService#moveFolder(String, String, ResourceResolver, ResourceResolver)}
     */
    @Deprecated
    String moveFolder(String dstpath, String srcpath, ResourceResolver resolver);

    /**
     * Moves a folder (including sub folders/assets) back to the Scene7 server.
     * 
     * @param dstpath
     *            destination path to the file in the repository
     * @param srcpath
     *            Original path of the folder in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access DAM asset resource / node
     * @param configResolver
     *            Sling ResourceResolver to access AEM-S7 cloud configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String moveFolder(String dstpath, String srcpath,
            ResourceResolver assetResolver, ResourceResolver configResolver);
}
