/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.constants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Defines the Scene7 asset types.
 */
public enum Scene7AssetType {
    IMAGE("Image"), VIDEO("Video"), TEMPLATE("Template"), PSD_TEMPLATE("PsdTemplate"), FLASH("Flash"), GENERIC("Generic"), MASTER_VIDEO(
            "MasterVideo"), FXG("Fxg"), VIEWER_PRESET("ViewerPreset"), MBR_SET("MbrSet"), CATALOG("Catalog");

    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7AssetType.class);

    private String type;

    private Scene7AssetType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.type;
    }

    /**
     * Tries to match the given type string to the actual enum
     * 
     * @param type
     *            String representing the asset type
     * @return The Enum representing the asset type, if the match is successful If the match is not successful, the GENERIC type will be
     *         returned
     */
    public static Scene7AssetType toScene7AssetType(String type) {
        Scene7AssetType assetType = null;

        Scene7AssetType[] assetTypes = values();
        for (Scene7AssetType validAssetType : assetTypes) {
            if (validAssetType.getValue().equals(type)) {
                assetType = validAssetType;
                break;
            }
        }

        if (assetType == null) {
            LOGGER.warn("Invalid Scene7 asset type '{}'! Using generic asset type!", type);

            assetType = GENERIC;
        }

        return assetType;
    }
}
