/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.importer;

/**
 * The LockUtils service can be used by components / services that have to import / upload Scene7 assets in order to avoid concurrency
 * issues.
 */
public interface LockAssetUtils {

    /**
     * Tries to obtain a lock for a DAM asset, with a maximum timeout period set by the {@code cq.dam.scene7.import.locktimeout} OSGi
     * property.
     * 
     * @param assetPath
     *            the path to the asset
     * @throws Exception
     *             in case the lock cannot be acquired
     */
    public abstract void lockAsset(String assetPath) throws Exception;

    /**
     * Releases the lock for a DAM asset.
     * 
     * @param assetPath
     *            the path to the asset
     */
    public abstract void unlockAsset(String assetPath);

}