/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.importer;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.model.Scene7Asset;

/**
 * The {@code Scene7ImportHandler} defines a Scene7 import handler which is able to import Scene7 assets into CQ DAM.
 */
public interface Scene7ImportHandler {

    public static final String SCR_PROP_NAME_S7_ASSET_TYPE = "scene7.asset.type";
    public static final String SCENE7_THUMBNAIL_RENDITION_NAME = "s7thumbnail.jpeg";
    public static final String SCENE7_THUMBNAIL_MIME_TYPE = "image/jpeg";
    public static final String PN_DAM_MIMETYPE = "dam:MIMEtype";

    /**
     * Sets the parameters needed for the asset import.
     * 
     * @param asset
     *            the asset
     * @param s7Config
     *            the Scene7 configuration
     * @throws Exception
     *             if any error occurs during asset import
     * @return the imported <code>Asset</code> in DAM
     * 
     *         The returned <code>Asset</code> underlying session is not guaranteed to be opened. Callers of this method should not rely on
     *         this session if making changes to the Assets's metadata
     */
    Asset importAsset(Scene7Asset asset, S7Config s7Config) throws Exception;

    /**
     * Imports a Scene7 asset as a sub-asset for an existing CQ DAM asset. <br>
     * <br>
     * Please note that the returned <code>Asset</code> underlying session is not guaranteed to be opened. Callers of this method should not
     * rely on this session if making changes to the Assets's metadata
     * 
     * @param asset
     *            the CQ DAM asset
     * @param subasset
     *            the Scene7 asset
     * @param s7Config
     *            the Scene7 configuration
     * @throws Exception
     *             if any error occurs during sub-asset import
     * @return the imported <code>Asset</code> in DAM
     */
    Asset importSubAsset(Asset asset, Scene7Asset subasset, S7Config s7Config) throws Exception;

    /**
     * Creates and saves the CQ DAM import folder for an asset.
     * 
     * @param asset
     *            the asset
     * @param s7Config
     *            the Scene7 configuration
     * @throws Exception
     *             if any error occurs during the folder creation
     */
    void createAssetImportFolder(Scene7Asset asset, S7Config s7Config) throws Exception;

}
