/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.importer;

import com.day.cq.dam.scene7.api.model.Scene7Asset;

/**
 * The <code>Scene7ImportHandlerLookupService</code> provides <code>Scene7ImportHandler</code> lookup services
 */
public interface Scene7ImportHandlerLookupService {

    /**
     * Returns a <code>Scene7ImportHandler</code> implementation capable of performing the import of the given <code>Scene7Asset</code>
     * 
     * @param asset
     *            - <code>Scene7Asset</code> used to perfrom the lookup
     * @return a <code>Scene7ImportHandler</code> implementation
     */
    public Scene7ImportHandler getImportHandler(Scene7Asset asset);
}
