/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.importer;

import com.day.cq.dam.scene7.api.S7Config;

/**
 * The {@code Scene7ImportService} is responsible for importing assets from Scene7 to CQ DAM.
 */
public interface Scene7ImportService {

    /**
     * Imports the Scene7 assets into CQ DAM by using the association between a Scene7 configuration and a target import folder. For more
     * details please check the {@link S7Config} documentation.
     * 
     * @param s7Config
     *            the Scene7 configuration for which the import should be performed
     */
    void importAssets(S7Config s7Config);

}
