/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

/**
 * The {@code UploadJobDetail} object is used for storing information related to Scene7 upload jobs.
 */
public interface UploadJobDetail {

    /**
     * @return s7 upload detail log message
     */
    public abstract String getLogMessage();

    /**
     * @return s7 log type job detail
     */
    public abstract String getLogType();

    /**
     * @return s7 asset type which was the target of this job detail
     */
    public abstract String getAssetType();

    /**
     * @return s7 asset name which was the target of this job detail
     */
    public abstract String getAssetName();

    /**
     * @return s7 asset handle which was the target of this job detail
     */
    public abstract String getAssetHandle();

}