/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.net;

public class NetUtils {
    public static String appendQuery(String url, String params) {
        if (params == null || params.length() == 0) {
            return url;
        }

        boolean amp = (params.charAt(0) == '&');
        boolean q = (params.charAt(0) == '?');

        if (url.indexOf("?") == -1) {
            if (amp) {
                return url + "?" + params.substring(1);
            } else if (q) {
                return url + params;
            } else {
                return url + "?" + params;
            }
        } else {
            if (url.endsWith("?")) {
                if (amp || q) {
                    return url + params.substring(1);
                } else {
                    return url + params;
                }
            } else {
                if (amp) {
                    return url + params;
                } else if (q) {
                    return url + "&" + params.substring(1);
                } else {
                    return url + "&" + params;
                }
            }
        }
    }
}
