/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.usage.api;

import java.util.List;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.PersistenceException;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.dam.api.Asset;
import com.day.cq.replication.ReplicationException;

/**
 * The <code>AssetUsageTracker</code> interface describes the methods for
 * recording and accessing the asset usage record.
 */
@ProviderType
public interface AssetUsageTracker {

    /** The usage count. */
    String USAGE_COUNT = "count";

    /** The last used. */
    String LAST_USED = "lastUsed";

    /** The asset usage type. */
    String USAGE_TYPE = "type";

    /**
     * Update the <code>asset</code> usages information with
     * <code>assetUsageRecord</code>.
     *
     * @param asset the asset to update
     * @param assetUsageRecord the new asset usage record
     * @throws RepositoryException the repository exception
     * @throws PersistenceException the persistence exception
     */
    void recordUsage(Asset asset, AssetUsageRecord assetUsageRecord)
            throws RepositoryException, PersistenceException, ReplicationException;

    /**
     * Gets the asset score.
     * 
     * @param asset asset for which score is required
     * @return the asset score
     */
    long getAssetScore(Asset asset);

    /**
     * The Class AggregateUsageInfo, defines the meta properties for the asset
     * usage information.
     */
    class AggregateUsageInfo {

        /** The solution type in which asset is used. */
        public String usageType;

        /**
         * The most recent time when this asset has been used with the
         * <code>solutionType</code>
         */
        public String lastUsedTime;

        /**
         * The number of times asset has been used with the
         * <code>solutionType</code>
         */
        public long usageCount;
    }

    /**
     * Gets the asset usage stats.
     *
     * @param asset the asset for which information is required
     * @param usagesType list of usages to be returned
     * @return the list of <code>AggregateUsageInfo</code> for all the solutions
     *         in which this <code>asset</code> has been used.
     */
    List<AggregateUsageInfo> getUsageStats(Asset asset, List<String> usagesType);
}
