/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.usage.api;

import org.apache.sling.api.resource.PersistenceException;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.dam.api.Asset;
import com.day.cq.replication.ReplicationException;

/**
 * The Interface UsageReplicationService provide APIs for replicating the asset
 * usage information between shared system.
 */
@ProviderType
public interface UsageReplicationService {

    /**
     * Checks if is asset is shred between system
     *
     * @param asset the asset to check
     * @return true, if is asset is shared between system
     */
    public boolean isSharedAsset(Asset asset);

    /**
     * Replicate the asset usage record with the shared system.
     *
     * @param asset for which usage information need to be replicated
     * @param usageRecord the AssetUsageRecord
     */
    public void replicateAssetUsageRecord(Asset asset,
            AssetUsageRecord usageRecord) throws PersistenceException,
            ReplicationException;
}
