/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.jcrclustersupport;

/**
 * The <code>ClusterAware</code> service interface may be implemented by
 * components interested in being made aware of the cluster state or changes
 * thereof the repository on which Sling primarily depends.
 * <p>
 * Upon registration and whenever certain changes in the registered JCR
 * Repository service occurrs registered services of this type are made aware of
 * the properties of the repository.
 * @deprecated Use {@link org.apache.sling.discovery.TopologyEventListener} instead.
 */
@Deprecated
public interface ClusterAware {

    /**
     * The name under which services must be registered.
     */
    String SERVICE = "com.day.cq.jcrclustersupport.ClusterAware";

    /**
     * Informs the service that no repository is currently bound.
     * <p>
     * This method is called upon two occasions:
     * <ul>
     * <li>When the service is first registered and no repository is bound</li>
     * <li>When a bound repository is unbound and no replacement is bound</li>
     * </ul>
     */
    void unbindRepository();

    /**
     * Informs the service on a bound repository.
     * <p>
     * This method is called upon three occasions:
     * <ul>
     * <li>When the service is first registered and a repository is bound</li>
     * <li>When an existing bound repository is replaced by another bound
     * repository</li>
     * <li>When a repository is being freshly bound</li>
     * <li>When a bound repository changes its master/slave (see
     * <code>isMaster</code>) state.</li>
     * </ul>
     *
     * @param repositoryId The ID of the repository node upon which Sling is
     *            running. If the repository ID is not available from the
     *            repository, this parameter is set to <code>null</code>.
     * @param clusterId The ID of the cluster upon which Sling is running. If
     *            the cluster ID is not available from the repository, this
     *            parameter is set to <code>null</code>.
     * @param isMaster <code>true</code> if the main repository is operating as
     *            the master node in the cluster. If this parameter is
     *            <code>false</code> the node is operating as the slave.
     */
    void bindRepository(String repositoryId, String clusterId, boolean isMaster);

}
