/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.mailer;

import com.day.cq.security.Authorizable;

import javax.jcr.RepositoryException;
import java.util.Iterator;

/**
 * Interface to mark a set of {@link Authorizable Authorizables} dedicated to
 * receive a Mailing.
 * This is more relaxed than to require a {@link com.day.cq.security.Group Group}
 * 
 * @see MailingService
 * @since 5.4
 * Use {@link AuthorizableMailingList}
 */
@Deprecated
public interface MailingList {

    /**
     * The members of this List
     * @return the {@link com.day.cq.security.Authorizable Authorizables} that
     * are part of this List.
     *
     * @throws RepositoryException in case of error  
     */
    Iterator<Authorizable> members() throws RepositoryException;



}
