/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

/**
 * Codes of Status a Mailing.
 * The Status is divided into two categories. One category is considered
 * erroneous. This can be tested with a call to {@link #isError() isError}
 * method.
 *
 * @see com.day.cq.mailer.MailingStatus#getStatusCode()
 * @since 5.4
 */
@SuppressWarnings({"UnusedDeclaration"})
public enum MailingStatusCode {

    /**
     * Initial state. mailing may change
     */
    NEW(false),

    /**
     * Mailing has been sent without error
     * @see MailingService#send(MessageTemplate, MailingList,javax.jcr.Session)
     */
    SENT(false),

    /**
     * There was an attempt to sent the mailing, that failed.
     * No reason given.
     * @see MailingService#send(MessageTemplate, MailingList,javax.jcr.Session)
     */
    ERROR(true),

    /**
     * There was an attempt to sent the mailing, that failed.
     * No {@link com.day.cq.mailer.MessageTemplate MessageTemplate} could be
     * created for the {@link com.day.cq.mailer.impl.Mailing Mailing}
     * @see MailingService#send(MessageTemplate, MailingList,javax.jcr.Session)
     */
    NO_TEMPLATE(true),

    /**
     * There was an attempt to sent the mailing, that failed.
     * No Gateway is registered to sent mailing
     * @see MessageGateway
     */
    NO_GATEWAY(true),

    /**
     * There was an attempt to sent the mailing, that failed.
     * No {@link com.day.cq.mailer.impl.MailingRecipient MailingRecipient} didn't
     * provide an address suited for this mailing (eg. no e-mail address)
     */
    NO_ADDRESS(true),

    /**
     * There was an attempt to sent the mailing that failed.
     * Template {@link com.day.cq.mailer.MessageTemplate MessageTemplate} provided
     * malformed values eg. e-mail addresses without "@"
     */
    INVALID_MESSAGE(true),

    /**
     * There was an attempt to sent the mailing, that failed.
     * The {@link MessageGateway MessageGateway} denied
     * relaying of the message
     */
    NOT_DELIVERABLE(true);

    private final boolean error;

    MailingStatusCode(boolean isError) {
        error = isError;
    }

    /**
     * True if the Status indicates a reason that prevented the Mailing from
     * being delivered
     * @return true if the state has to be considered abnormal false otherwise
     */
    public boolean isError() {
        return error;
    }
}
