/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer.commons;

import com.day.cq.mailer.MailingList;
import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;

import javax.jcr.RepositoryException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

/**
 * MailingList that takes a {@link com.day.cq.security.Group Group's} members as
 * its members. The List unfolds the transitive dependencies of
 * {@link com.day.cq.security.Group#members() Group membership}
 * 
 * @see com.day.cq.mailer.MailingList
 * @since 5.4
 * 
 * @deprecated
 * @since 6.2
 */
public class GroupMailingList implements MailingList {

    private final Group group;
    private Predicate filterPredicate;

    /**
     * @param group
     *            this list represents
     */
    public GroupMailingList(Group group) {
        this(group, null);
    }

    /**
     * Constructor to set an optional filter predicate.
     * 
     * @param group
     *            group this list represents
     * @param filterPredicate
     *            an optional filter predicate to filter the group members when
     *            accessing the {@link #members()} method.
     */
    public GroupMailingList(Group group, Predicate filterPredicate) {
        this.group = group;
        this.filterPredicate = filterPredicate;
    }

    // ------------------------------------------------< MailingList
    // >-----------

    /**
     * @return all members of the Group including transitive members
     * @throws RepositoryException
     */
    public Iterator<Authorizable> members() throws RepositoryException {
        if (filterPredicate == null) {
            return new GroupUnfoldingIterator(group.members());
        } else {
            return (Iterator<Authorizable>) IteratorUtils.filteredIterator(new GroupUnfoldingIterator(group.members()),
                    filterPredicate);
        }
    }

    /**
     * This Iterator iterates includes all
     * {@link com.day.cq.security.Authorizable Authorizables} of the backing
     * Iterator. It "unfolds" any transitive membership. This means, if the
     * backing iterator contains a Group A that has a Group B as member, this
     * iterator will have contain the members of Group B
     */
    private static final class GroupUnfoldingIterator implements Iterator<Authorizable> {

        private final Stack<Iterator<Authorizable>> iterators = new Stack<Iterator<Authorizable>>();

        private final HashSet<String> served = new HashSet<String>();
        private Authorizable next;

        GroupUnfoldingIterator(Iterator<Authorizable> base) {
            iterators.push(base);
            next = seek();
        }

        public boolean hasNext() {
            return next != null;
        }

        public Authorizable next() {
            if (!hasNext()) {
                throw new NoSuchElementException();
            }
            Authorizable serve = next;
            next = seek();
            return serve;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seek() {
            while (!iterators.isEmpty()) {
                Iterator<Authorizable> current = iterators.pop();
                while (current != null && current.hasNext()) {
                    Authorizable test = current.next();
                    if (!served.contains(test.getID())) {
                        served.add(test.getID());
                        if (current.hasNext()) {
                            iterators.push(current);
                        }
                        if (!test.isUser()) {
                            iterators.push(((Group) test).members());
                        }
                        return test;
                    }
                }
            }
            return null;
        }
    }
}