/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer.email;

import java.nio.charset.Charset;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

import org.apache.commons.mail.Email;

import com.day.cq.mailer.MessageTemplate;

/**
 * Define a {@link MessageTemplate Template} that can be used to build Emails.
 * 
 * @param <Type>
 * @see MessageTemplate
 * @since 5.4
 */
public interface EmailTemplate<Type extends Email> extends MessageTemplate<Type> {

    /**
     * @param text to set as body of this message
     */
    void setText(String text);

    /**
     * @return message body set on template
     */
    String getText();

    /**
     * @param subject to be used for the email
     */
    void setSubject(String subject);

    /**
     * @return the subject set to this template
     */
    String getSubject();

    /**
     * @param from and Address to be used as from
     * @throws AddressException in case the address is in invalid format
     */
    void setFrom(InternetAddress from) throws AddressException;

    /**
     * @return the address set
     */
    InternetAddress getFrom();

    /**
     * @param charSet to use for sending
     */
    void setCharSet(Charset charSet);

    /**
     * @return charSet set
     */
    Charset getCharSet();
}
