/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer.email;

import javax.jcr.RepositoryException;

import org.apache.commons.mail.Email;
import org.apache.sling.api.resource.Resource;

/**
 * An interface to reference a an OSGI Service for creating
 * {@link EmailTemplate EmailTemplates}.<br>
 * This allow to share an instance wide configuration, like a From address or charSet
 * @param <Type>
 * @since 5.4
 */
public interface EmailTemplateFactory<Type extends Email> {

    /**
     * @param resource containing the data to be set on the email-template
     * @return template or <code>null</code> if the Resource didn't allow to build
     *         one
     * @throws RepositoryException in case of error accessing the underlying Repository
     */
    EmailTemplate<? extends Type> create(Resource resource) throws RepositoryException;
}
