/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer.email;

import java.net.URI;

import javax.jcr.RepositoryException;

import org.apache.commons.mail.Email;

/**
 * An interface to reference a an OSGI Service for creating
 * {@link EmailTemplate EmailTemplates}. that are build form a a web page<br>
 * This allow to share an instance wide configuration, like a From address or charSet
 * @param <Type>
 * @since 5.4
 */
public interface RetrieverEmailTemplateFactory<Type extends Email> {

    /**
     * @param uri to use as content of the Template to build
     * @return template or <code>null</code> if not able to build one
     * @throws RepositoryException in case of exception building the template
     */
    EmailTemplate<? extends Type> create(URI uri) throws RepositoryException;
}
