/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mcm.api.newsletter;

import com.day.cq.mailer.AuthorizableMailingList;
import com.day.cq.mailer.MailingList;
import com.day.cq.mailer.MessageTemplate;

import javax.jcr.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

/**
 * This object describes a newsletter and gives status
 * information etc.
 * todo: extend messageTemplate
 * @since 5.4
 */
public interface NewsLetter {

    /**
     * Return the content path.
     * @return The content path.
     */
    String getPath();

    /**
     * Get the subject for sending this newsletter.
     * @return The subject.
     */
    String getSubject();

    /**
     * Set the subject for this newsletter.
     * @param subject the subject
     */
    void setSubject(String subject);

    /**
     * @return used to build this letter
     * @since 5.4
     */
    Session getSession();

    /**
     * Sets the receivers of this List.
     * @param list of {@link com.day.cq.security.Authorizable Authorizables}
     *        this Letter should be send to.
     * @deprecated Use {@link #setAuthorizableMailingList(AuthorizableMailingList)} instead
     */
    @Deprecated
    void setMailingList(MailingList list);

    /**
     * Access the Subscribers to this Newsletter
     * @return all Subscribers of this Newsletter
     * @deprecated Use {@link #getAuthorizableMailingList()} instead
     */
    @Deprecated
    MailingList getMailingList();

    /**
     * Sets the receivers of this List.
     * @param list of {@link org.apache.jackrabbit.api.security.user.Authorizable}
     *        this Letter should be send to.
     */
    void setAuthorizableMailingList(AuthorizableMailingList list);

    /**
     * Access the Subscribers to this Newsletter
     * @return all Subscribers of this Newsletter
     */
    AuthorizableMailingList getAuthorizableMailingList();

    /**
     * @return The from address or null.
     */
    InternetAddress getFromAddress();

    /**
     * @param value the from address
     * @throws javax.mail.internet.AddressException if the value doesn't
     * {@link javax.mail.internet.InternetAddress#validate()} validate validate}
     *
     */
    void setFromAddress(InternetAddress value) throws AddressException;

    /**
     * @return The Template build from this newsletter
     */
    MessageTemplate getMessageTemplate();
}