/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mcm.api.newsletter;

import com.day.cq.mailer.MailingList;
import com.day.cq.mailer.MailingStatus;
import com.day.cq.mcm.core.NewsletterHelper;
import com.day.cq.security.Authorizable;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.wcm.api.Page;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.net.URI;

/**
 * The newsletter service can be used to send newsletters or to retrieve
 * information about the subscribers.
 * 
 * @since 5.4
 * @deprecated Use {@link NewsletterEmailService} instead
 */
@Deprecated
public interface NewsletterService {

    /**
     * Send the newsletter.
     * 
     * @param newsletter
     *            The newsletter
     * @return <code>true</code< if the newsletter could be send; <code>false</code>
     *         otherwise.
     * @throws java.security.AccessControlException
     *             if the Session lacks the privilege to send
     * @throws javax.jcr.RepositoryException
     *             in case of error accessing the Repository
     * @deprecated Use {@link NewsletterEmailService#sendNewsletter(NewsLetter, ResourceResolver)} instead
     */
    @Deprecated
    MailingStatus sendNewsletter(NewsLetter newsletter) throws RepositoryException;

    /**
     * Builds a {@link NewsLetter Newsletter} from the given {@link Page Page}.<br>
     * The Page is considered to represent the content of the Newsletter<br>
     * Its up to the implementation what are the preconditions on processing the
     * Page.
     * 
     * @param page
     *            containing the data of the Newsletter
     * @return the Newsletter build maybe <code>null</code> if the Resource is
     *         not suited to build a Newsletter
     * @throws RepositoryException
     *             in case of Exception accessing the Repository
     * @deprecated Use {@link NewsletterEmailService#buildNewsletter(Page)} instead
     */
    @Deprecated
    NewsLetter buildNewsletter(Page page) throws RepositoryException;

    /**
     * Builds a Newsletter and take the URI to retrieve the content.
     * 
     * @param resource
     *            to build Newsletter of
     * @param contentUri
     *            to take as host information to be shown in sent Newsletter
     * @return the Newsletter build
     * @throws RepositoryException
     *             in case of error accessing the Repository
     * @see #buildNewsletter(Page)
     * @deprecated Use {@link NewsletterEmailService#buildNewsletter(Resource, URI)} instead
     */
    @Deprecated
    NewsLetter buildNewsletter(Resource resource, URI contentUri) throws RepositoryException;

    /**
     * Build a MailingList for the given group-name
     * 
     * @param groupName
     *            to build a MailingList for
     * @param session
     *            to retrieve the List
     * @return the List build
     * @throws NoSuchAuthorizableException
     *             if the group-name is not found
     * @throws RepositoryException
     *             in case of error accessing the Repository
     * @deprecated Use {@link NewsletterEmailService#createMailingList(String, Session)}
     */
    @Deprecated
    MailingList createMailingList(String groupName, Session session) throws NoSuchAuthorizableException,
            RepositoryException;

    /**
     * Create a MailingList for testing. The aim is to have a Profile to use for
     * personalization and a {@link com.day.cq.security.User User} to an e-mail
     * address to send the mail to. The Address has to be given with the
     * RequestParameter {@link NewsletterHelper#PARAM_TEST_TO} or defaults to
     * the Request's User's
     * {@link com.day.cq.security.profile.Profile#getPrimaryMail()} primary
     * Mail} (e.g. ResourceResolver.adaptTo(User.class)). The Profile has to be
     * given by the RequestParameter named
     * {@link NewsletterHelper#PARAM_TEST_PROFILE} and the Id as value.
     * 
     * @param request
     *            to read the input from
     * @return a MailingList with on Recipient or <code>null</code> if
     *         parameters are not set
     * @throws RepositoryException
     *             in case of error accessing the Repository
     * @deprecated Use {@link NewsletterEmailService#createTestMailingList(SlingHttpServletRequest)}
     */
    @Deprecated
    MailingList createTestMailingList(SlingHttpServletRequest request) throws RepositoryException;

}
