/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.resource.Resource;

import java.util.Map;

/**
 * A service that is used to access a remote Adobe Campaign instance.
 */
public interface CampaignConnector {

    /**
     * Determines the webservice config to be used. This method respects inheritance.
     *
     * @param resource The resource to get the webservice config for
     * @return The webservice config
     * @throws ACConnectorException if the webservice configuration is not present or invalid
     */
    Configuration getWebserviceConfig(Resource resource) throws ACConnectorException;

    /**
     * <p>Retrieves the credentials from the specified webservice config.</p>
     *
     * @param config The webservice config
     * @return The credentials
     * @throws ACConnectorException if there are no credentials present or the credentials
     *                              could not be decrypted
     */
    CampaignCredentials retrieveCredentials(Configuration config) throws ACConnectorException;

    /**
     * <p>Calls a remote function on the campaign instance.</p>
     *
     * <p>Note that the caller is required to use {@link CallResults#destroy()} after
     * processing the result of the remote function call.</p>
     *
     * <p>The remote function needs to reside in the default namespace (/jssp/nms/).
     * To call remote functions in a generic namespace, use
     * {@link GenericCampaignConnector#callGeneric} instead.</p>
     *
     * @param name The name of the function to be called (in /jssp/nms/; the value must not
     *             include /jssp/nms/)
     * @param fctParams The parameters of the function call (name/value parameters)
     * @param credentials The credentials to be used for the call
     * @return The result of the function call
     * @throws ACConnectorException If the remote function could not be called or returned an unexpected status
     */
    CallResults callFunction(String name, Map<String, String> fctParams,
                             CampaignCredentials credentials) throws ACConnectorException;

    /**
     * <p>Posts data to a remote function on the campaign instance.</p>
     *
     * <p>Note that the caller is required to use {@link CallResults#destroy()} after
     * processing the result of the remote function call.</p>
     *
     * <p>The remote function needs to reside in the default namespace (/jssp/nms/).
     * To call remote functions in a generic namespace, use
     * {@link GenericCampaignConnector#postGeneric} instead.</p>
     *
     * @param name The name of the function to be called (in /jssp/nms/; the value must not
     *             include /jssp/nms/)
     * @param data The data to post (name/value)
     * @param credentials The credentials to be used for the call
     * @return The result of the function call
     * @throws ACConnectorException If the remote function could not be called or returned an unexpected status
     */
    CallResults postFunction(String name, Map<String, String> data,
                             CampaignCredentials credentials) throws ACConnectorException;

}
