/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

/**
 * <p>Reflects the current status of a newsletter.</p>
 *
 * <p>Implementations should be immutable.</p>
 */
public interface NewsletterStatus {

    /**
     * Internal status - no status available (not yet published to Adobe Campaign)
     */
    int UNAVAILABLE = Integer.MIN_VALUE;

    /**
     * Internal status - newsletter activation or publication to Adobe Campaign failed
     */
    int FAILED = -3;

    /**
     * Internal status - status could not be determined because the delivery is missing
     * on Adobe Campaign
     */
    int MISSING = -2;

    /**
     * Internal status - delivery is being prepared for publishing to Adobe Campaign
     */
    int PREPARING = -1;

    /**
     * Gets the status as a numeric code.
     *
     * @return The status (numeric)
     */
    int getStatusCode();

    /**
     * Gets the status as a String code.
     *
     * @return The status (textual)
     */
    String getStatusString();

    /**
     * Gets an (internationalized) variant of the status in a human-readable format.
     *
     * @return The human-readable status
     */
    String getStatusMessage();

}
