/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign.importer;

import com.day.cq.wcm.designimporter.api.ImporterConstants;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.TextComponentTagHandler;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Constants;
import org.osgi.service.component.ComponentContext;

/**
 * The TagHandlerFactory that takes care of creating personalized (MCM) text components.
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = PersonalizedTextHandlerFactory.TAG_PATTERN)
})
public class PersonalizedTextHandlerFactory implements TagHandlerFactory {

    protected static final String RESOURCE_TYPE_PERS_TEXT = "mcm/components/personalization";

    static public final String TAG_PATTERN = "<(p|span|div)\\s+.*data-cq-component=\"(?i)personalized-text\".*?>";

    private String resourceType;

    public TagHandler create() {
        TextComponentTagHandler textComponentTagHandler = new TextComponentTagHandler();
        textComponentTagHandler.setResourceType(resourceType);
        return textComponentTagHandler;
    }

    /**
     * The bundle activator method. For internal use.
     * @param context
     */
    @Activate
    protected void activate(ComponentContext context) {
        resourceType = OsgiUtil.toString(context.getProperties()
                .get(ImporterConstants.PN_RESOURCE_TYPE), RESOURCE_TYPE_PERS_TEXT);
    }

}
