/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mcm.core;

import java.util.ArrayList;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.wcm.emulator.Emulator;
import com.day.cq.wcm.emulator.EmulatorGroup;

/**
 * <code>NewsletterEmulatorGroup</code> ...
 */
public class NewsletterEmulatorGroup implements EmulatorGroup {

    /**
     * The default title for newsletter emulator groups.
     */
    public static final String DEFAULT_TITLE = "E-Mail Clients";

    private Resource resource;
    private List<Emulator> emulators = new ArrayList<Emulator>();

    NewsletterEmulatorGroup(Resource r) {
        resource = r;
    }

    public String getTitle() {
        return ResourceUtil.getValueMap(resource).get(JcrConstants.JCR_TITLE, DEFAULT_TITLE);
    }

    public String getDescription() {
        return ResourceUtil.getValueMap(resource).get(JcrConstants.JCR_DESCRIPTION, "");
    }

    public String getPath() {
        return null;
    }

    public String getName() {
        return ResourceUtil.getName(resource);
    }

    public List<Emulator> getEmulators() {
        return emulators;
    }

    public void setEmulators(List<Emulator> emulators) {
        if (this.emulators.size() > 0) {
            this.emulators.clear();
        }
        this.emulators.addAll(emulators);
    }
}
