/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mcm.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.wcm.emulator.Emulator;
import com.day.cq.wcm.emulator.EmulatorGroup;
import com.day.cq.wcm.emulator.EmulatorProvider;

/**
 * <code>NewsletterEmulatorProvider</code> provides emulators for newsletter pages.
 */
@Component(metatype = false)
@Service
public class NewsletterEmulatorProvider implements EmulatorProvider {

    private static final String GROUP_PATH = "/libs/mcm/components/newsletter/emailclient";
    private static final String NEWSLETTER_RESOURCE_TYPE = "mcm/components/newsletter/page";
    private static final String SIGHTLY_NEWSLETTER_RESOURCE_TYPE = "mcm/campaign/components/campaign_newsletterpage";
    private static final String BASE_NAME = "base";

    public List<Emulator> getEmulators(Resource resource) {
        ResourceResolver rr = resource.getResourceResolver();
        List<Emulator> emulators = new ArrayList<Emulator>();
        Iterator<Resource> children = rr.listChildren(rr.getResource(GROUP_PATH));
        while (children.hasNext()) {
            Resource child = children.next();
            if (!BASE_NAME.equals(ResourceUtil.getName(child))) {
                emulators.add(child.adaptTo(Emulator.class));
            }
        }
        return emulators;
    }

    public boolean handles(Resource resource) {
        Resource content;
        if (!resource.getPath().endsWith(JcrConstants.JCR_CONTENT)) {
            content = resource.getResourceResolver().getResource(resource, JcrConstants.JCR_CONTENT);
        } else {
            content = resource;
        }
        return ResourceUtil.isA(content, NEWSLETTER_RESOURCE_TYPE) || ResourceUtil.isA(content, SIGHTLY_NEWSLETTER_RESOURCE_TYPE);
    }

    public List<EmulatorGroup> getEmulatorGroups(Resource resource) {
        List<EmulatorGroup> groups = new ArrayList<EmulatorGroup>();
        Resource groupRes = resource.getResourceResolver().getResource(GROUP_PATH);
        NewsletterEmulatorGroup group = new NewsletterEmulatorGroup(groupRes);
        group.setEmulators(getEmulators(resource));
        groups.add(group);
        return groups;
    }
}
