/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.emailprovider;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.mcm.emailprovider.service.EmailServiceProvider;
import com.day.cq.mcm.emailprovider.types.EmailServiceActions;
import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;


public class EmailServiceFormsHelper {
	/** The logger. */
    private static final Logger log = LoggerFactory.getLogger(EmailServiceFormsHelper.class.getName());
        
    private static final String FOUNDATION_FORM_START = "foundation/components/form/start";
    
    private static final String FOUNDATION_FORM_END = "foundation/components/form/end";
    
    private static final String CTA_EMAIL_ID = "mcm/components/cta-form/emailId";
    
    private static final String PARAM_PATH = "cfgpath";
    
    
    
    private EmailServiceFormsHelper(){
    	//no instances
    }
        
    public static List<Node> addFormFields(Resource formResource,SlingHttpServletRequest request,SlingHttpServletResponse response){
    	SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
    	SlingScriptHelper sling = bindings.getSling();
    	if(sling==null)
    	{
    		log.error("Error retrieving form parameters: SlingScriptHelper is null");
    		return null;
    	}
    	EmailServiceProvider emailServiceProvider = sling.getService(EmailServiceProvider.class);
    	ConfigurationManager cfgMgr = request.getResourceResolver().adaptTo(ConfigurationManager.class);
    	Configuration configuration = getConfiguration(formResource,cfgMgr);
    	EmailService emailService = emailServiceProvider.getEmailService(configuration);
    	Map<String,Object> map = ResourceUtil.getValueMap(formResource);
    	List<FieldDescription> formFields = null;
    	try{
    		formFields = (List<FieldDescription>)emailService.execute(EmailServiceActions.GET_FORM_FIELDS, map, configuration);
    		Iterator<Resource> existingFields = FormsHelper.getFormElements(formResource);
    		List<Resource> existingFieldsList = new ArrayList<Resource>();
    		while(existingFields.hasNext())
    			existingFieldsList.add(existingFields.next());
    		if(matchFieldSets(formFields,existingFieldsList))
    			return new ArrayList<Node>();
    		deleteOldNodes(existingFieldsList,formResource.getParent().adaptTo(Node.class));
    		return addNodes(formFields,formResource);
    	}catch(Exception e){
    		log.error("Error retrieving form parameters: "  + e.getMessage());
    	}
    	
    	//left here, fetching fields each time to ensure that changes in fields at the serviceprovider reflects in the form.
    	//so basically, what you do is first match both fields fetched and already existing in form, if the set doesn't match exactly
    	//delete all fields in the form and add the fetched fields
    	
    	return null;
    } 

    private static String getNodeName(String tentativeName, Node parentNode) throws RepositoryException{
    	int suffix = 0;
    	String _name = tentativeName + "_";
    	while(parentNode.hasNode(_name + suffix))
    		suffix++;
    	return parentNode.hasNode(tentativeName) ? _name + suffix : tentativeName;
    }
    private static List<Node> addNodes(List<FieldDescription> formFields,
			Resource formResource) {
    	List<Node> addedNodes = new ArrayList<Node>();
    	try{
        	Node formParent = formResource.getParent().adaptTo(Node.class);
        	Resource formEnd = getFormEnd(formResource);
        	Node orderBefore = formEnd.adaptTo(Node.class);
        	for(FieldDescription fd : formFields){
        		Resource resource = fd.getFieldResource();
        		ResourceMetadata rm = resource.getResourceMetadata();
        		String resourceType = resource.getResourceType();
        		String nodeName = getNodeName(resourceType.substring(resourceType.lastIndexOf('/') + 1),formParent);
    	    	Node node = formParent.addNode(nodeName,"nt:unstructured");                
    	        node.setProperty(ESConstants.CQ_FORM_FIELD_NAME,fd.getName());
    	        node.setProperty("sling:resourceType",resourceType);
    	        node.setProperty("sling:resourceSuperType",rm.get("sling:resourceSuperType").toString());//note the resource is a SyntheticResource and hence supertype extracted from metadata
    	        node.setProperty("required",fd.isRequired());
    	        if(fd.getConstraintType()!=null)
    	        	node.setProperty("constraintType",fd.getConstraintType());
    	    	formParent.orderBefore(node.getName(), orderBefore.getName());
    	    	addedNodes.add(node);
        	}
        	formParent.getSession().save();
    	}catch(Exception e){
    		log.error("Error occured while adding form fields: " + e.getMessage());
    	}
    	return addedNodes;
		
	}
	private static Resource getFormEnd(Resource formResource) {
		if(!ResourceUtil.isA(formResource, FOUNDATION_FORM_START))
			return null;
        Resource resource = null;
        boolean found = false;
    	try
    	{
	        Resource formParent = formResource.getParent();
	        Iterator<Resource> iter = formParent.listChildren();
	        Boolean start = false;     
	        while(iter.hasNext())
	        {
	            resource = iter.next();
	            if(start && ResourceUtil.isA(resource, FOUNDATION_FORM_END))         
	            {
	            	found = true;
	            	break;
	            }
	            if(!start && resource.getName().equals(formResource.getName()))
	            {
	                start = true;
	            }               
	        }
    	}
    	catch (Exception e)
    	{
    		log.error(e.getMessage());
    	}
    	if(found)
    		return resource;
    	return null;
	}

	private static void deleteOldNodes(List<Resource> existingSiblings, Node parentNode) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
		//Assumption, all resource in the iteration have same parent
		Node node = null;
		for(Resource resource: existingSiblings){
			node = resource.adaptTo(Node.class);
			node.remove();
		}
		parentNode.getSession().save();
	}
	private static boolean matchFieldSets(
			List<FieldDescription> formFields,
			List<Resource> existingFields) {

		Map<String,Resource> existingFieldMap = new HashMap<String,Resource>();
    	for(Resource fRes: existingFields)
    	{
    		ValueMap values = ResourceUtil.getValueMap(fRes);
    		String name = values.get(ESConstants.CQ_FORM_FIELD_NAME,String.class);
    		if(name==null)
    			continue;
    		existingFieldMap.put(name, fRes);
    	}
    	for(FieldDescription formField: formFields){
    		Resource existingFieldRes = existingFieldMap.get(formField.getName());
    		if(existingFieldRes==null && formField.isRequired())
    			return false;
    		else
    			continue;
    	}
    	return true;
	}
	private static Configuration getConfiguration(Resource formResource, ConfigurationManager cfgMgr) {
        
        Configuration configuration = null;
        final ValueMap values = ResourceUtil.getValueMap(formResource);
        String path = values.get(PARAM_PATH,String.class);
        if (path != null) {
            configuration = cfgMgr.getConfiguration(path);
        }
        return configuration;
    }
}
