/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.service;

import com.day.cq.mcm.emailprovider.EmailService;
import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * This interface will be used to retrieve an Email service based on the passed 
 * cloud service configuration.
 */
public interface EmailServiceProvider {
    /**
     * This API will retrieve an EmailService instance based on the cloud service configuration
     * passed as parameter.
     * @param configuration The cloud service configuration parameter.
     * @return The EmailService corresponding to the cloud service or null if not found.
     */
    public EmailService getEmailService(Configuration configuration);
    
    /**
     * This API will retrieve an EmailService instance based on the provider type string.
     * @param providerName The email service provider name.  
     * @return The EmailService corresponding to the connection parameters or null if not found.
     */
    public EmailService getEmailService(String providerName);
}
